 ; Ŀ
 ;   Pong.                                                                 
 ;   Copyright 1994, 2007 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Ramod - randomly modify a number by a percentage of its value.        
 ;   Arguments: Num, the number.                                           
 ;              Perc, the percentage to change.                            
 ;   Calls Ranae, Returns a number.                                        
 ; 
 (DEFUN RAMOD (num perc / raval upordn moda)
  (setq raval (ranae))
  (setq upordn (ranae))
  (setq moda (* num perc raval 0.0001))
  (if (< upordn 50)
      (- num moda)
      (+ num moda)))
 ; Ŀ
 ;   Subroutine Ramod end.                                                 
 ; 

 ; Ŀ
 ;   Ranae - make a random number between 0 and 99.                        
 ;   Takes no arguments, calls nothing, returns a number.                  
 ; 
 (DEFUN RANAE (/ s)
  (setq s (getvar "cdate"))
  (setq s (rtos s 2 32))
  (read (substr s (1- (strlen s)))))
 ; Ŀ
 ;   Ranae end.                                                            
 ; 

 ; Ŀ
 ;   Pong.                                                                 
 ; 
 (DEFUN C:PONG (/ a vs ctr w pa pb hi movx movy maxx minx maxy miny csize entt
                                   osmo *error* boxout llenam rlenam cnam cent)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq hi (getvar "highlight"))
  (setvar "highlight" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make a local error handler.  Note that this is never explicitly       
 ;   called as Pong only exits with an error.                              
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (if llenam (entdel llenam))
   (if rlenam (entdel rlenam))
   (if cnam (entdel cnam))
   (if boxout (entdel boxout))
   (setvar "highlight" hi)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get the screen height and calculate the ball size, movement per       
 ;   cycle, and maximum and minimum X and Y coordinates.                   
 ; 
  (setq a (getvar "screensize"))           ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))            ; view width/height ratio
  (setq vs (* (getvar "viewsize") 0.5))    ; view height in drawing units
  (setq pa (setq ctr (getvar "viewctr")))  ; centre point of screen
  (setq w (* vs a ))                       ; view half width
 ; Ŀ
 ;   Maximum and minimum coordinates.                                      
 ; 
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
  (setq maxy (+ (cadr ctr) vs))
  (setq miny (- (cadr ctr) vs))
  (setq csize (/ (- maxx minx) 80.0))      ; ball size
 ; Ŀ
 ;   Draw an outline and centreline polyline box.                          
 ; 
  (command ".pline" (list maxx maxy) (list maxx miny)
                    (list minx miny) (list minx maxy)
                    (polar ctr (* pi 0.5) vs)
                    (polar ctr (* pi 1.5) vs)
                    (polar ctr (* pi 0.5) vs)
                    (list maxx maxy) "")
  (setq boxout (entlast))
 ; Ŀ
 ;   Adjust the view halfwidth to move the paddles in slightly.            
 ; 
  (setq w (* w 0.97))
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
 ; Ŀ
 ;   Get start point and initial direction.                                
 ; 
  (setq movinc (/ w 500.0))
  (setq movx0 (setq movx movinc))
  (setq movy0 (setq movy movinc))
 ; Ŀ
 ;   Adjust max and min for circle diameter.                               
 ; 
  (setq maxx (- maxx csize))
  (setq minx (+ minx csize))
  (setq maxy (- maxy csize))
  (setq miny (+ miny csize))
 ; Ŀ
 ;   Draw the circle.                                                      
 ; 
  (setq cent pa)
;  (command "circle" pa csize)
  (command "donut" "0" csize pa "")
  (setq cnam (entlast))
 ; Ŀ
 ;   Draw the left paddle.                                                 
 ; 
  (setq padfrc 12)  ; paddle height as screen fraction
  (setq plmid (polar ctr pi w))
  (command ".trace" (/ vs 100) (polar plmid (/ pi 2) (/ vs padfrc))
                               (polar plmid (* pi 1.5) (/ vs padfrc)) "")
  (setq llenam (entlast))
 ; Ŀ
 ;   Draw the right paddle.                                                
 ; 
  (setq prmid (polar ctr 0 w))
  (command ".trace" (/ vs 100) (polar prmid (/ pi 2) (/ vs padfrc))
                               (polar prmid (* pi 1.5) (/ vs padfrc)) "")
  (setq rlenam (entlast))
 ; Ŀ
 ;   And bounce the ball.                                                  
 ; 
  (setq num 0)  
  (while t
        (princ)
 ; Ŀ
 ;   If we're at the right side of the screen, reverse the x movement      
 ;   and randomly adjust the y (vertical) to add a random element to the   
 ;   bounce angle.                                                         
 ;   Also increment the cycle counter.                                     
 ; 
        (cond ((>= (car cent) maxx)
               (setq movx (- movx))
               (setq movy (ramod movy 25))
               (setq num (1+ num)))
 ; Ŀ
 ;   Left side: reverse x, randomly adjust y, increment cycle counter.     
 ; 
              ((<= (car cent) minx)
               (setq movx (- movx))
               (setq movy (ramod movy 25))
               (setq num (1+ num)))
 ; Ŀ
 ;   Also if we are at the 99th cycle, bounce off the middle.              
 ; 
              ((and (= num 16)
                    (<= (abs (- (car cent) (car ctr))) (/ csize 2)))
               (setq num 0)
               (setq movx (- movx)))
 ; Ŀ
 ;   Top of the screen: reverse y, randomly adjust x.                      
 ; 
              ((>= (cadr cent) maxy)
               (setq movy (- movy))
               (setq movx (ramod movx 25)))
 ; Ŀ
 ;   Bottom of the screen: reverse y, randomly adjust x.                   
 ; 
              ((<= (cadr cent) miny)
               (setq movy (- movy))
               (setq movx (ramod movx 25))))
 ; Ŀ
 ;   Make sure that neither move value has been randomly adjusted to       
 ;   something ludicrous.                                                  
 ; 
        (cond ((> movx (* 2 movx0))
               (setq movx movx0))
              ((< movx (* -2 movx0))
               (setq movx (- movx0))))
        (cond ((> movy (* 2 movy0))
               (setq movy movy0))
              ((< movy (* -2 movy0))
               (setq movy (- movy0))))
 ; Ŀ
 ;   Make a new point, move the circle there.                              
 ; 
        (setq pa (list (+ (car pa) movx) (+ (cadr pa) movy)))
        (command "move" cnam "" cent pa)
 ;      (grdraw cent pa 3)
        (setq cent pa)
 ; Ŀ
 ;   Each cycle should consist of a ball move and a paddle move, so that   
 ;   the cycle time remains constant and the ball doesn't accelerate and   
 ;   decelerate noticeably.                                                
 ;   If we are moving towards the right paddle, move it to follow the      
 ;   circle.                                                               
 ; 
        (if (minusp movx)
            (command "move" llenam "" plmid
                                   (setq plmid (list (car plmid) (cadr pa))))
            (command "move" rlenam "" prmid
                                   (setq prmid (list (car prmid) (cadr pa))))))
 (princ))